<?php


 /* Calling a PHP Function */
if(isset($_GET['savePass_activateAccount'])){
savePass_activateAccount();
}

if(isset($_GET['logToConsole'])){
logToConsole();
}




 /* Main PHP Function */
 function savePass_activateAccount() 	{

	header('Content-type: application/json');
	require_once($_SERVER['DOCUMENT_ROOT'] . '/z_config/config.php');

 
	$response = array();

	if ($_POST) {
		
		$first_password = $_POST['first_password'];	
		$confirm_password = $_POST['confirm_password'];	
		$tokenValue = $_POST['tokenValue'];	
				
		$reg_date = date('d.m.Y', time());
		$lst_update_timestamp = date('d.m.Y', time());

		//error_log('first_password:  ---  ' . $first_password);
		//error_log('confirm_password:  ---  ' . $confirm_password);		
		//error_log('tokenValue:  ---  ' . $tokenValue);
		//error_log('lst_update_timestamp:  ---  ' . $lst_update_timestamp);
		//exit();	


				//password match checking
				if(strcmp($first_password, $confirm_password) !== 0){				
					//error_log('password_mismatch' . $first_password);
					$response['status'] = 'password_mismatch';
					$response['message'] = 'The password does not match.';
					echo json_encode($response);
					exit();
				}

				 
				
			//check if token is valid/correct +++++++++++ users_activation	
			$stmt1 = $dbcon->prepare("SELECT id, status, email, member_uid FROM users_activation WHERE hashed_key =?");
			$stmt1->execute(array($tokenValue));
			while($row = $stmt1->fetch(PDO::FETCH_ASSOC)) {				
				$db_itm_id = $row['id']; 
				$db_itm_status = $row['status']; 
				$db_itm_email = $row['email']; 
				$db_itm_member_uid = $row['member_uid']; 
						}
				//1. checking if token is valid/correct		
				if ( $db_itm_id < 1 ) 
				{			
					//error_log('invalid_token' . $tokenValue);
					
					$response['status'] = 'invalid_token'; 
					$response['message'] = 'Supplied token is invalid.';
					echo json_encode($response);
					exit();						
					}  	
				//2. checking if activation/password set is done	
				if ( $db_itm_status == 1 ) 
				{			
					//error_log('activation already done' . $tokenValue);
					
					$response['status'] = 'activated';
					$response['message'] = 'Account activated already.';
					echo json_encode($response);
					exit();						
					}  
				//3. hashing password	
				$hashed_password = md5($first_password);
				
				//4. create user account in users table
				$status = 1;
				$query = "INSERT INTO users ( name, pass, mail, created, status ) VALUES ( :name, :pass, :mail, :created, :status )";
					$stmt = $dbcon->prepare( $query );		
					$stmt->bindParam(':name', $db_itm_email) ;
					$stmt->bindParam(':pass', $hashed_password) ;						
					$stmt->bindParam(':mail', $db_itm_email) ;	
					$stmt->bindParam(':created', $reg_date) ;					
					$stmt->bindParam(':status', $status) ;							
						if ( $stmt->execute() ) {							
							
								//getting last_inserted_id
								//$acct_uid = $dbcon->lastInsertId();
								//error_log('New UID: ' . $acct_uid);			
			 
								//update users_activation table
								$queryB = "UPDATE users_activation SET status = 1, date_activated = :reg_date WHERE id = :db_itm_id";
									$stmtB = $dbcon->prepare( $queryB );
									$stmtB->bindParam(':reg_date', $reg_date);
									$stmtB->bindParam(':db_itm_id', $db_itm_id);
									$stmtB->execute();									

								//update users_activation table
								$queryC = "UPDATE tbl_member_profile_individual SET activation_status = 2 WHERE id = :db_itm_member_uid";
									$stmtC = $dbcon->prepare( $queryC );
									$stmtC->bindParam(':db_itm_member_uid', $db_itm_member_uid);
									$stmtC->execute();	



						$response['status'] = 'success';
						$response['message'] = 'Member account activation is sucessfull.';	
							
					} else {
						
						$response['status'] = 'error'; // could not register
						$response['message'] = 'An error occured, contact EHCON-Technical.';
					}			
			
	}
		
		echo json_encode($response);

}


 /* Send debug code to the Javascript console
 function logToConsole() 
	{
	
		debug_to_console('Mami is sleeping.');	
		

	$response = array();


	$response['status'] = 'success'; 
	$response['message'] = 'EHxxxxxxxxxxxxsfully.';
	echo json_encode($response);
	
}  */ 

//debug_to_console('Mami is savePDF.');	



/* Send debug code to the Javascript console */ 
function debug_to_console($data) {
    if(is_array($data) || is_object($data))
	{
		echo("<script>console.log('PHP Debug: ".json_encode($data)."');</script>");
	} else {
		echo("<script>console.log('PHP Debug: ".$data."');</script>");
	}
}



