<?php


 /* Calling a PHP Function */
if(isset($_GET['requestPassResetLink'])){
requestPassResetLink();
}




 /* Main PHP Function */
 function requestPassResetLink() 	{

	header('Content-type: application/json');
	require_once($_SERVER['DOCUMENT_ROOT'] . '/z_config/config.php');

 
	$response = array();

	if ($_POST) {
		
		$req_email = $_POST['req_email'];	
		//error_log('now:  ---  ' .$req_email );
	
		$active_date = date('Y-m-d');
		$active_time = date('H:i:s');		
		$active_timestamp = date('Y-m-d H:i:s', time());
		
		
		$now = new DateTime(); //now
		$nowX = $now->format('Y-m-d H:i:s'); 
		//echo $now->format('Y-m-d H:i:s'); // 2021-09-11 01:01:55
		//error_log('now:  ---  ' .$nowX );

		$hours = 24; // hours amount (integer) you want to add
		$modified = (clone $now)->add(new DateInterval("PT{$hours}H")); // use clone to avoid modification of $now object
		$now24X = $modified->format('Y-m-d H:i:s'); 
		//echo "\n". $modified->format('Y-m-d H:i:s'); // 2021-09-12 13:01:55	
		//error_log('24 hrs :  ---  ' .$now24X );	
		
		//$expiry_timestamp = $active_timestamp = 24hr;

		
		
		//error_log('active_date:  ---  ' . $active_date);
		//error_log('active_timestamp:  ---  ' . $active_timestamp);		
		//error_log('active_time:  ---  ' . $active_time);				
		//error_log('req_email:  ---  ' . $req_email);
		//exit();	

				
			// hashing password	
			//$hashed_password = md5($password_login);				 
				
			//selecting from users table ++++++++++++++++++++++ 	
			$stmt1 = $dbcon->prepare("SELECT * FROM users WHERE name =? ");
			$stmt1->execute(array($req_email));
			while($row = $stmt1->fetch(PDO::FETCH_ASSOC)) {				
				$db_itm_uid = $row['uid']; 
				$db_itm_mail = $row['mail']; 
				$db_itm_status = $row['status']; 
						}
				//1. checking if email is valid		
				if ( $db_itm_uid < 1 ) 
				{			
					//error_log('xxxx' . $xxxx);					
					$response['status'] = 'invalid_email'; 
					$response['message'] = 'invalid_email';
					echo json_encode($response);
					exit();						
					}  	
				//2. checking if account is active	
				if ( $db_itm_status == 0 ) 
				{			
					//error_log('xxxx' . $xxxx);					
					$response['status'] = 'inactive_account';
					$response['message'] = 'inactive_account';
					echo json_encode($response);
					exit();						
					} 
				
				// send password reset link (hash the token, expiry period, uid, email save to password_request table)
		
				//3. pass reset TOKEN generation ----------------------------------
				$pass_reset_token = md5($db_itm_mail.$db_itm_uid.time());
				//error_log('pass_reset_token:  ---  ' . $pass_reset_token);
				$pass_reset_url = 'https://portal.ehcon.eservices.ng/z_modules/user/reset_password.php?token='.$pass_reset_token;
				//error_log('pass_reset_url:  ---  ' . $pass_reset_url);			

				//4. insert to users_activation here: ---------------------------------------------	
				$query = "INSERT INTO users_pass_reset_request ( member_uid, email, entry_timestamp, token_key, expiry_date ) VALUES ( :member_uid, :email, :entry_timestamp, :token_key, :expiry_date )";	
					$stmt = $dbcon->prepare( $query );		
					$stmt->bindParam(':member_uid', $db_itm_uid) ;		
					$stmt->bindParam(':email', $db_itm_mail) ;
					$stmt->bindParam(':entry_timestamp', $nowX) ;
					$stmt->bindParam(':token_key', $pass_reset_token) ;
					$stmt->bindParam(':expiry_date', $now24X) ;
						if ( $stmt->execute() ) {
								//$usr_act_id = $dbcon->lastInsertId();
								//error_log('usr_act_id ID: ' . $usr_act_id);
					
							//send pass reset link email to member
							send_pass_reset_request_mail ($db_itm_mail, $pass_reset_url);							
					
								//************************************	
								//************************************	
								//************************************	
								//insert into users log table
								$a_module = 'User'; $a_action = 'Password reset request'; $a_details = 'Request for password reset';
								$query = "INSERT INTO users_actions_log ( a_date, a_time, a_uid, a_uname, a_module, a_action, a_details ) VALUES ( :a_date, :a_time, :a_uid, :a_uname, :a_module, :a_action, :a_details )";
									$stmt = $dbcon->prepare( $query );		
									$stmt->bindParam(':a_date', $active_date) ;
									$stmt->bindParam(':a_time', $active_time) ;						
									$stmt->bindParam(':a_uid', $db_itm_uid) ;	
									$stmt->bindParam(':a_uname', $db_itm_mail) ;					
									$stmt->bindParam(':a_module', $a_module) ;						
									$stmt->bindParam(':a_action', $a_action) ;	
									$stmt->bindParam(':a_details', $a_details) ;							
									$stmt->execute();	
								//************************************	
								//************************************	
								//************************************	


							$response['status'] = 'success';
							$response['message'] = 'password_reset_link_send.';	

					
					} else {
					
							$response['status'] = 'error';
							$response['message'] = 'password_reset_link_failed.';
					}			

			
	}
		
		echo json_encode($response);

}



function send_pass_reset_request_mail ($email_to, $pass_reset_url) {
		

$to = $email_to;
$subject = 'EHCON Portal Password Reset Request';

$headers['From'] = 'EHCON-MRLP Portal <info@ehcon.eservices.ng>';
$headers['MIME-Version'] = 'MIME-Version: 1.0';
$headers['Content-type'] = 'text/html; charset=iso-8859-1';

$message = '
<html>
<head>
    <title>EHCON Portal Password Reset Request</title>
</head>
<body>

  <img src="https://portal.ehcon.eservices.ng/assets/media/logos/ehcon.png" width="149" height="158" alt="Embedded Image">
	<br><br>
    <p style="text-align: justify"> <font face="Lucida Sans" size="2">
	Dear <b>'.$email_to.'</b>,
	<br><br>
	
	A request to reset your account password on EHCON Membership Portal is received.<br>Click the link below to reset your account password:
	<br><br> 
	
	<b> <li> <a href=" '.$pass_reset_url.' "> '.$pass_reset_url.' </a> </b>
	
	<br><br>

	Please note that the reset link will expire and become invalid after 24 hours.

	<br><br>
	
	Thank you.<br>
	Registration & Membership Department,<br>
	Environmental Health Council of Nigeria (EHCON),<br>
	Federal Secreteriat, Abuja.<br>
	info@ehcon.gov.ng
	</font></p>
	
</body>
</html>
';

		$result = mail($to, $subject, $message, $headers);
		
}
 
/* Send debug code to the Javascript console */ 
function debug_to_console($data) {
    if(is_array($data) || is_object($data))
	{
		echo("<script>console.log('PHP Debug: ".json_encode($data)."');</script>");
	} else {
		echo("<script>console.log('PHP Debug: ".$data."');</script>");
	}
}



